/**
  ******************************************************************************
  * @file    cp_tag.h 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   include file for the tag heler functions of the sample communication protocol
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 


#ifndef CP_TAG_H
#define CP_TAG_H

enum
{
    TAG_BITMASK_ID_PRESENT=0,
    TAG_BITMASK_AUTH_PRESENT,
    TAG_BITMASK_RESPONSE_PRESENT
};

#define SET_BIT_IN_BITMASK(mask,bit) ((mask) |= (1<<bit))
#define TEST_BIT_IN_BITMASK(mask,bit) (mask & (1 << bit))

typedef struct CP_DYNTAGSTRUCT
{
    struct CP_DYNTAGSTRUCT *m_Next;
    unsigned long m_Tag;
    unsigned long m_Len;
    unsigned char m_MarshalledVal[1];    
} CP_DYNTAGSTRUCT, *PCP_DYNTAGSTRUCT;

extern CP_STATUSCODE    cp_DynTagFromTLV(unsigned long p_Tag, unsigned long p_Len,unsigned char *p_Val,CP_DYNTAGSTRUCT **p_DynReceiver);
extern void             cp_InsertDynTagAtEnd(CP_DYNTAGSTRUCT **p_DynReceiver,CP_DYNTAGSTRUCT *p_NextDynTagPtr);            
extern void             cp_DeleteTagChain(CP_DYNTAGSTRUCT **p_DynReceiver);
extern void             cp_TestForAuthPacket(CP_DYNTAGSTRUCT *p_DynTagStruct,PCP_PROCESSOR p_Processor);
extern CP_STATUSCODE    cp_DissectIncomingPacket(CP_DYNTAGSTRUCT *p_DynTagStruct,PCP_PROCESSOR p_Processor,unsigned long *p_OrgSeq);

extern CP_STATUSCODE    cp_CB_AuthenticateClient(CP_DYNTAGSTRUCT *p_DynTagStruct);
extern CP_STATUSCODE    cp_EvaluateIncomingPacket(PCP_PROCESSOR p_Processor,CP_DYNTAGSTRUCT *p_DynTagStruct);



extern CP_STATUSCODE    cp_SyntaxCheck(unsigned char *p_Buf,unsigned long p_BufLen,CP_DYNTAGSTRUCT **p_DynReceiver,unsigned short *p_TagBitmask);

#endif

